/****** Object:  StoredProcedure [dbo].[P_EST_PROD_PRECO_ALT_CRIAR_PROGRAMACAO]    Script Date: 04/02/2014 12:39:26 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_PROD_PRECO_ALT_CRIAR_PROGRAMACAO]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_EST_PROD_PRECO_ALT_CRIAR_PROGRAMACAO]
GO
GO
--EXEC P_EST_PROD_PRECO_ALT_CRIAR_PROGRAMACAO 1,1945
CREATE PROCEDURE P_EST_PROD_PRECO_ALT_CRIAR_PROGRAMACAO @CD_EMP INT,@CD_ALT_PRECO INT
WITH ENCRYPTION AS
SET NOCOUNT ON;
DECLARE @CD_ALT_PRECO_NOVO INT
PRINT 'P_EST_PROD_PRECO_ALT_CRIAR_PROGRAMACAO'
SET @CD_ALT_PRECO_NOVO=ISNULL((SELECT
							MAX(CD_ALT_PRECO)
						  FROM
							EST_PROD_PRECO_ALT
						  WHERE
							CD_EMP=@CD_EMP),0)+1
						  

CREATE TABLE #RsPreco(CD_EMP INT,
					  CD_FILIAL INT,
					  CD_ALT_PRECO INT,
					  CD_PROD INT,
					  VLR_TABELA MONEY,
					  CD_USU INT,
					  DT_FIM_AGENDA DATETIME)

INSERT INTO  #RsPreco
select
	EST_PROD_PRECO_ALT.CD_EMP,
	EST_PROD_PRECO_ALT_PRC_FILIAL.CD_FILIAL,
	EST_PROD_PRECO_ALT.CD_ALT_PRECO,
	EST_PROD_PRECO_ALT_CPL.CD_PROD,
	0 AS VLR_TABELA,
	EST_PROD_PRECO_ALT.CD_USU,
	EST_PROD_PRECO_ALT.DT_FIM_AGENDA
from
	EST_PROD_PRECO_ALT INNER JOIN EST_PROD_PRECO_ALT_CPL ON
	EST_PROD_PRECO_ALT.CD_EMP = EST_PROD_PRECO_ALT_CPL.CD_EMP AND
	EST_PROD_PRECO_ALT.CD_ALT_PRECO = EST_PROD_PRECO_ALT_CPL.CD_ALT_PRECO 
	INNER JOIN EST_PROD_PRECO_ALT_PRC_FILIAL ON
	EST_PROD_PRECO_ALT.CD_EMP = EST_PROD_PRECO_ALT_PRC_FILIAL.CD_EMP AND
	EST_PROD_PRECO_ALT.CD_ALT_PRECO = EST_PROD_PRECO_ALT_PRC_FILIAL.CD_ALT_PRECO
	LEFT OUTER JOIN EST_PROD_PRECO_ALT_AGENDADO_ANTIGO_APLICACAO ON
	EST_PROD_PRECO_ALT.CD_EMP = EST_PROD_PRECO_ALT_AGENDADO_ANTIGO_APLICACAO.CD_EMP AND
	EST_PROD_PRECO_ALT.CD_ALT_PRECO = EST_PROD_PRECO_ALT_AGENDADO_ANTIGO_APLICACAO.CD_ALT_PRECO_ORIGEM 
WHERE
	EST_PROD_PRECO_ALT.CD_EMP=@CD_EMP
	AND EST_PROD_PRECO_ALT.CD_ALT_PRECO=@CD_ALT_PRECO
	AND EST_PROD_PRECO_ALT_AGENDADO_ANTIGO_APLICACAO.CD_ALT_PRECO_ORIGEM IS NULL

UPDATE
	P
SET 
	P.VLR_TABELA = EST_PROD_PRECO.VLR_TABELA
FROM
	#RsPreco p INNER JOIN EST_PROD_PRECO ON
	P.CD_EMP = EST_PROD_PRECO.CD_EMP AND
	P.CD_FILIAL = EST_PROD_PRECO.CD_FILIAL AND
	P.CD_PROD = EST_PROD_PRECO.CD_PROD 


INSERT INTO EST_PROD_PRECO_ALT
(CD_EMP,
CD_ALT_PRECO,
TP_ALT_PRECO,
ZERO_OFERTA,
DT_CAD,
CD_USU,
DS_ALT_PRECO,
APLICADO,
DT_APLICACAO,
DT_AGENDADA,
ORIGEM_PRECO,
APLICAR_PRECO_FAMILIA,
PRECO_AGENDADO,
DT_FIM_AGENDA)
SELECT
	DISTINCT @CD_EMP,
	@CD_ALT_PRECO_NOVO,
	0 AS TP_ALT_PRECO,
	0 AS ZERO_OFERTA,
	CONVERT(CHAR(10),GETDATE(),112) DT_CAD,
	CD_USU,
	'ALTERACAO CRIADADA PROGRAMACAO DO GRUPO ' + CONVERT(VARCHAR(10),CD_ALT_PRECO) DS_ALT_PRECO,
	0 AS APLICADO,
	DT_FIM_AGENDA AS DT_APLICACAO,
	DT_FIM_AGENDA,
	0 AS ORIGEM_PRECO,
	0 AS APLICAT_PRECO_FAMILIA,
	0 AS PRECO_AGENDADO,
	NULL DT_FIM_AGENDA
FROM
	#RsPreco

INSERT INTO EST_PROD_PRECO_ALT_CPL
(CD_EMP,
CD_ALT_PRECO,
CD_PROD,
VLR_TABELA,
VLR_OFERTA,
VLR_CUSTO,
CD_FILIAL,
CD_NF,
TP_NIVEL_PERC,
PERC_MARGEM,
DS_PERC_MARGEM,
TP_CUSTO,
DS_TP_CUSTO,
VLR_TABELA_ORIGINAL,
VLR_TABELA_VIGENTE,
VLR_OFERTA_VIGENTE,
CD_ALT_PRECO_ANTERIOR,
PERC_VARIACAO_AUMENTO)   
SELECT
	DISTINCT CD_EMP,
	@CD_ALT_PRECO_NOVO,
	CD_PROD,
	VLR_TABELA,
	0 AS VLR_OFERTA,
	0 AS VLR_CUSTO,
	0 AS CD_FILIAL,
	0 AS CD_NF,
	0 AS TP_NIVEL_PERC,
	0 AS PERC_MARGEM,
	'' AS DS_PERC_MARGEM,
	0 AS TP_CUSTO,
	'' AS DS_TP_CUSTO,
	0 AS VLR_TABELA_ORIGINAL,
	0 AS VLR_TABELA_VIGENTE,
	0 AS VLR_OFERTA_VIGENTE,
	CD_ALT_PRECO,
	0 AS PERC_VARIACAO_AUMENTO
FROM 
	#RsPreco

INSERT INTO EST_PROD_PRECO_ALT_PRC_FILIAL	
(CD_EMP,
CD_ALT_PRECO,
CD_FILIAL,
CD_GRUPO)
SELECT
	DISTINCT p.CD_EMP,
	@CD_ALT_PRECO_NOVO,
	p.CD_FILIAL,
	EST_PRECIFICACAO_GRP_PRECO_FILIAL.CD_GRUPO
	FROM
		#RsPreco p inner join EST_PRECIFICACAO_GRP_PRECO_FILIAL on
		p.CD_EMP = EST_PRECIFICACAO_GRP_PRECO_FILIAL.CD_EMP AND
		p.CD_FILIAL = EST_PRECIFICACAO_GRP_PRECO_FILIAL.CD_FILIAL 
		INNER JOIN EST_PRECIFICACAO_GRP_PRECO ON
		EST_PRECIFICACAO_GRP_PRECO_FILIAL.CD_EMP = EST_PRECIFICACAO_GRP_PRECO.CD_EMP AND
		EST_PRECIFICACAO_GRP_PRECO_FILIAL.CD_GRUPO = EST_PRECIFICACAO_GRP_PRECO.CD_GRUPO 
	WHERE	
		EST_PRECIFICACAO_GRP_PRECO.TIPO_GRUPO=0


INSERT INTO EST_PROD_PRECO_ALT_AGENDADO_ANTIGO_APLICACAO
(CD_EMP,
CD_ALT_PRECO,
CD_ALT_PRECO_ORIGEM,
DT_CAD)
SELECT
	DISTINCT CD_EMP,
	@CD_ALT_PRECO_NOVO,
	CD_ALT_PRECO,
	GETDATE()
FROM
	#RsPreco

DROP TABLE #RsPreco
